/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.DiagCornerDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredCubeSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
public final class CheckeredPanelSegmentSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean second = (Boolean)state.m_61143_((Property)PropertyHolder.SECOND);
            return switch (type) {
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> CheckeredPanelSegmentSkipPredicate.testAgainstCheckeredPanelSegment(dir, second, adjState, side);
                case BlockType.FRAMED_CHECKERED_CUBE_SEGMENT -> CheckeredPanelSegmentSkipPredicate.testAgainstCheckeredCubeSegment(dir, second, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CheckeredPanelSegmentSkipPredicate.testAgainstSlabCorner(dir, second, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> CheckeredPanelSegmentSkipPredicate.testAgainstSlabEdge(dir, second, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> CheckeredPanelSegmentSkipPredicate.testAgainstCornerPillar(dir, second, adjState, side);
                case BlockType.FRAMED_STAIRS -> CheckeredPanelSegmentSkipPredicate.testAgainstStairs(dir, second, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CheckeredPanelSegmentSkipPredicate.testAgainstVerticalStairs(dir, second, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CheckeredPanelSegmentSkipPredicate.testAgainstHalfStairs(dir, second, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> CheckeredPanelSegmentSkipPredicate.testAgainstVerticalHalfStairs(dir, second, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> CheckeredPanelSegmentSkipPredicate.testAgainstSmallCornerSlopePanel(dir, second, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> CheckeredPanelSegmentSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, second, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> CheckeredPanelSegmentSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, second, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> CheckeredPanelSegmentSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, second, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> CheckeredPanelSegmentSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, second, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> CheckeredPanelSegmentSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, second, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> CheckeredPanelSegmentSkipPredicate.testAgainstMasonryCornerSegment(dir, second, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredPanelSegmentSkipPredicate.getDiagCornerDir(dir, second, side).isEqualTo(CheckeredPanelSegmentSkipPredicate.getDiagCornerDir(adjDir, adjSecond, side.m_122424_())) || CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(CheckeredPanelSegmentSkipPredicate.getCornerDir(adjDir, adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
    private static boolean testAgainstCheckeredCubeSegment(Direction dir, boolean second, BlockState adjState, Direction side) {
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredPanelSegmentSkipPredicate.getDiagCornerDir(dir, second, side).isEqualTo(CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return CheckeredPanelSegmentSkipPredicate.getCornerDir(dir, second, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    public static DiagCornerDir getDiagCornerDir(Direction dir, boolean second, Direction side) {
        if (side == dir) {
            return switch (side) {
                case Direction.NORTH -> {
                    if (second) {
                        yield DiagCornerDir.NORTH_UW_DE;
                    }
                    yield DiagCornerDir.NORTH_UE_DW;
                }
                case Direction.SOUTH -> {
                    if (second) {
                        yield DiagCornerDir.SOUTH_UE_DW;
                    }
                    yield DiagCornerDir.SOUTH_UW_DE;
                }
                case Direction.WEST -> {
                    if (second) {
                        yield DiagCornerDir.WEST_UN_DS;
                    }
                    yield DiagCornerDir.WEST_US_DN;
                }
                case Direction.EAST -> {
                    if (second) {
                        yield DiagCornerDir.EAST_US_DN;
                    }
                    yield DiagCornerDir.EAST_UN_DS;
                }
                default -> DiagCornerDir.NULL;
            };
        }
        return DiagCornerDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean second, Direction side) {
        if (Utils.isY(side)) {
            boolean x = Utils.isX(dir);
            boolean up = side == Direction.UP;
            return CornerDir.fromDirections(side, dir, second == up ^ x ? dir.m_122428_() : dir.m_122427_());
        }
        if (side.m_122434_() != dir.m_122434_()) {
            boolean x = Utils.isX(dir);
            boolean cw = side == dir.m_122427_();
            return CornerDir.fromDirections(side, dir, second == cw ^ x ? Direction.DOWN : Direction.UP);
        }
        return CornerDir.NULL;
    }
}

